<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ExperienceContext;
use PaypalServerSdkLib\Models\TrustlyPaymentRequest;

/**
 * Builder for model TrustlyPaymentRequest
 *
 * @see TrustlyPaymentRequest
 */
class TrustlyPaymentRequestBuilder
{
    /**
     * @var TrustlyPaymentRequest
     */
    private $instance;

    private function __construct(TrustlyPaymentRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new trustly payment request Builder object.
     */
    public static function init(string $name, string $countryCode): self
    {
        return new self(new TrustlyPaymentRequest($name, $countryCode));
    }

    /**
     * Sets experience context field.
     */
    public function experienceContext(?ExperienceContext $value): self
    {
        $this->instance->setExperienceContext($value);
        return $this;
    }

    /**
     * Initializes a new trustly payment request object.
     */
    public function build(): TrustlyPaymentRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
