<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Address;
use PaypalServerSdkLib\Models\SetupTokenCardExperienceContext;
use PaypalServerSdkLib\Models\SetupTokenRequestCard;

/**
 * Builder for model SetupTokenRequestCard
 *
 * @see SetupTokenRequestCard
 */
class SetupTokenRequestCardBuilder
{
    /**
     * @var SetupTokenRequestCard
     */
    private $instance;

    private function __construct(SetupTokenRequestCard $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new setup token request card Builder object.
     */
    public static function init(): self
    {
        return new self(new SetupTokenRequestCard());
    }

    /**
     * Sets name field.
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets number field.
     */
    public function number(?string $value): self
    {
        $this->instance->setNumber($value);
        return $this;
    }

    /**
     * Sets expiry field.
     */
    public function expiry(?string $value): self
    {
        $this->instance->setExpiry($value);
        return $this;
    }

    /**
     * Sets security code field.
     */
    public function securityCode(?string $value): self
    {
        $this->instance->setSecurityCode($value);
        return $this;
    }

    /**
     * Sets brand field.
     */
    public function brand(?string $value): self
    {
        $this->instance->setBrand($value);
        return $this;
    }

    /**
     * Sets billing address field.
     */
    public function billingAddress(?Address $value): self
    {
        $this->instance->setBillingAddress($value);
        return $this;
    }

    /**
     * Sets verification method field.
     */
    public function verificationMethod(?string $value): self
    {
        $this->instance->setVerificationMethod($value);
        return $this;
    }

    /**
     * Sets experience context field.
     */
    public function experienceContext(?SetupTokenCardExperienceContext $value): self
    {
        $this->instance->setExperienceContext($value);
        return $this;
    }

    /**
     * Sets network transaction reference field.
     */
    public function networkTransactionReference($value): self
    {
        $this->instance->setNetworkTransactionReference($value);
        return $this;
    }

    /**
     * Initializes a new setup token request card object.
     */
    public function build(): SetupTokenRequestCard
    {
        return CoreHelper::clone($this->instance);
    }
}
