<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\PortablePostalAddressMediumGrained;

/**
 * Builder for model PortablePostalAddressMediumGrained
 *
 * @see PortablePostalAddressMediumGrained
 */
class PortablePostalAddressMediumGrainedBuilder
{
    /**
     * @var PortablePostalAddressMediumGrained
     */
    private $instance;

    private function __construct(PortablePostalAddressMediumGrained $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new portable postal address medium grained Builder object.
     */
    public static function init(string $countryCode): self
    {
        return new self(new PortablePostalAddressMediumGrained($countryCode));
    }

    /**
     * Sets address line 1 field.
     */
    public function addressLine1(?string $value): self
    {
        $this->instance->setAddressLine1($value);
        return $this;
    }

    /**
     * Sets address line 2 field.
     */
    public function addressLine2(?string $value): self
    {
        $this->instance->setAddressLine2($value);
        return $this;
    }

    /**
     * Sets admin area 2 field.
     */
    public function adminArea2(?string $value): self
    {
        $this->instance->setAdminArea2($value);
        return $this;
    }

    /**
     * Sets admin area 1 field.
     */
    public function adminArea1(?string $value): self
    {
        $this->instance->setAdminArea1($value);
        return $this;
    }

    /**
     * Sets postal code field.
     */
    public function postalCode(?string $value): self
    {
        $this->instance->setPostalCode($value);
        return $this;
    }

    /**
     * Initializes a new portable postal address medium grained object.
     */
    public function build(): PortablePostalAddressMediumGrained
    {
        return CoreHelper::clone($this->instance);
    }
}
