<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\PayeeBase;
use PaypalServerSdkLib\Models\PlatformFee;

/**
 * Builder for model PlatformFee
 *
 * @see PlatformFee
 */
class PlatformFeeBuilder
{
    /**
     * @var PlatformFee
     */
    private $instance;

    private function __construct(PlatformFee $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new platform fee Builder object.
     */
    public static function init(Money $amount): self
    {
        return new self(new PlatformFee($amount));
    }

    /**
     * Sets payee field.
     */
    public function payee(?PayeeBase $value): self
    {
        $this->instance->setPayee($value);
        return $this;
    }

    /**
     * Initializes a new platform fee object.
     */
    public function build(): PlatformFee
    {
        return CoreHelper::clone($this->instance);
    }
}
