<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ExperienceContext;
use PaypalServerSdkLib\Models\P24PaymentRequest;

/**
 * Builder for model P24PaymentRequest
 *
 * @see P24PaymentRequest
 */
class P24PaymentRequestBuilder
{
    /**
     * @var P24PaymentRequest
     */
    private $instance;

    private function __construct(P24PaymentRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new p24 payment request Builder object.
     */
    public static function init(string $name, string $email, string $countryCode): self
    {
        return new self(new P24PaymentRequest($name, $email, $countryCode));
    }

    /**
     * Sets experience context field.
     */
    public function experienceContext(?ExperienceContext $value): self
    {
        $this->instance->setExperienceContext($value);
        return $this;
    }

    /**
     * Initializes a new p24 payment request object.
     */
    public function build(): P24PaymentRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
