<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\GooglePayCard;
use PaypalServerSdkLib\Models\PortablePostalAddressMediumGrained;

/**
 * Builder for model GooglePayCard
 *
 * @see GooglePayCard
 */
class GooglePayCardBuilder
{
    /**
     * @var GooglePayCard
     */
    private $instance;

    private function __construct(GooglePayCard $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new google pay card Builder object.
     */
    public static function init(): self
    {
        return new self(new GooglePayCard());
    }

    /**
     * Sets name field.
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets number field.
     */
    public function number(?string $value): self
    {
        $this->instance->setNumber($value);
        return $this;
    }

    /**
     * Sets expiry field.
     */
    public function expiry(?string $value): self
    {
        $this->instance->setExpiry($value);
        return $this;
    }

    /**
     * Sets last digits field.
     */
    public function lastDigits(?string $value): self
    {
        $this->instance->setLastDigits($value);
        return $this;
    }

    /**
     * Sets type field.
     */
    public function type(?string $value): self
    {
        $this->instance->setType($value);
        return $this;
    }

    /**
     * Sets brand field.
     */
    public function brand(?string $value): self
    {
        $this->instance->setBrand($value);
        return $this;
    }

    /**
     * Sets billing address field.
     */
    public function billingAddress(?PortablePostalAddressMediumGrained $value): self
    {
        $this->instance->setBillingAddress($value);
        return $this;
    }

    /**
     * Initializes a new google pay card object.
     */
    public function build(): GooglePayCard
    {
        return CoreHelper::clone($this->instance);
    }
}
