<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\EpsPaymentRequest;
use PaypalServerSdkLib\Models\ExperienceContext;

/**
 * Builder for model EpsPaymentRequest
 *
 * @see EpsPaymentRequest
 */
class EpsPaymentRequestBuilder
{
    /**
     * @var EpsPaymentRequest
     */
    private $instance;

    private function __construct(EpsPaymentRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new eps payment request Builder object.
     */
    public static function init(string $name, string $countryCode): self
    {
        return new self(new EpsPaymentRequest($name, $countryCode));
    }

    /**
     * Sets experience context field.
     */
    public function experienceContext(?ExperienceContext $value): self
    {
        $this->instance->setExperienceContext($value);
        return $this;
    }

    /**
     * Initializes a new eps payment request object.
     */
    public function build(): EpsPaymentRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
