<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CardStoredCredential;
use PaypalServerSdkLib\Models\NetworkTransactionReference;

/**
 * Builder for model CardStoredCredential
 *
 * @see CardStoredCredential
 */
class CardStoredCredentialBuilder
{
    /**
     * @var CardStoredCredential
     */
    private $instance;

    private function __construct(CardStoredCredential $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new card stored credential Builder object.
     */
    public static function init(string $paymentInitiator, string $paymentType): self
    {
        return new self(new CardStoredCredential($paymentInitiator, $paymentType));
    }

    /**
     * Sets usage field.
     */
    public function usage(?string $value): self
    {
        $this->instance->setUsage($value);
        return $this;
    }

    /**
     * Sets previous network transaction reference field.
     */
    public function previousNetworkTransactionReference(?NetworkTransactionReference $value): self
    {
        $this->instance->setPreviousNetworkTransactionReference($value);
        return $this;
    }

    /**
     * Initializes a new card stored credential object.
     */
    public function build(): CardStoredCredential
    {
        return CoreHelper::clone($this->instance);
    }
}
