<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\CapturePaymentInstruction;

/**
 * Builder for model CapturePaymentInstruction
 *
 * @see CapturePaymentInstruction
 */
class CapturePaymentInstructionBuilder
{
    /**
     * @var CapturePaymentInstruction
     */
    private $instance;

    private function __construct(CapturePaymentInstruction $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new capture payment instruction Builder object.
     */
    public static function init(): self
    {
        return new self(new CapturePaymentInstruction());
    }

    /**
     * Sets platform fees field.
     */
    public function platformFees(?array $value): self
    {
        $this->instance->setPlatformFees($value);
        return $this;
    }

    /**
     * Sets disbursement mode field.
     */
    public function disbursementMode(?string $value): self
    {
        $this->instance->setDisbursementMode($value);
        return $this;
    }

    /**
     * Sets payee receivable fx rate id field.
     */
    public function payeeReceivableFxRateId(?string $value): self
    {
        $this->instance->setPayeeReceivableFxRateId($value);
        return $this;
    }

    /**
     * Initializes a new capture payment instruction object.
     */
    public function build(): CapturePaymentInstruction
    {
        return CoreHelper::clone($this->instance);
    }
}
