<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use stdClass;

/**
 * The total order amount with an optional breakdown that provides details, such as the total item
 * amount, total tax amount, shipping, handling, insurance, and discounts, if any.<br/>If you specify
 * `amount.breakdown`, the amount equals `item_total` plus `tax_total` plus `shipping` plus `handling`
 * plus `insurance` minus `shipping_discount` minus discount.<br/>The amount must be a positive number.
 * For listed of supported currencies and decimal precision, see the PayPal REST APIs <a
 * href="/docs/integration/direct/rest/currency-codes/">Currency Codes</a>.
 */
class AmountWithBreakdown implements \JsonSerializable
{
    /**
     * @var string
     */
    private $currencyCode;

    /**
     * @var string
     */
    private $value;

    /**
     * @var AmountBreakdown|null
     */
    private $breakdown;

    /**
     * @param string $currencyCode
     * @param string $value
     */
    public function __construct(string $currencyCode, string $value)
    {
        $this->currencyCode = $currencyCode;
        $this->value = $value;
    }

    /**
     * Returns Currency Code.
     * The [three-character ISO-4217 currency code](/api/rest/reference/currency-codes/) that identifies
     * the currency.
     */
    public function getCurrencyCode(): string
    {
        return $this->currencyCode;
    }

    /**
     * Sets Currency Code.
     * The [three-character ISO-4217 currency code](/api/rest/reference/currency-codes/) that identifies
     * the currency.
     *
     * @required
     * @maps currency_code
     */
    public function setCurrencyCode(string $currencyCode): void
    {
        $this->currencyCode = $currencyCode;
    }

    /**
     * Returns Value.
     * The value, which might be:<ul><li>An integer for currencies like `JPY` that are not typically
     * fractional.</li><li>A decimal fraction for currencies like `TND` that are subdivided into
     * thousandths.</li></ul>For the required number of decimal places for a currency code, see [Currency
     * Codes](/api/rest/reference/currency-codes/).
     */
    public function getValue(): string
    {
        return $this->value;
    }

    /**
     * Sets Value.
     * The value, which might be:<ul><li>An integer for currencies like `JPY` that are not typically
     * fractional.</li><li>A decimal fraction for currencies like `TND` that are subdivided into
     * thousandths.</li></ul>For the required number of decimal places for a currency code, see [Currency
     * Codes](/api/rest/reference/currency-codes/).
     *
     * @required
     * @maps value
     */
    public function setValue(string $value): void
    {
        $this->value = $value;
    }

    /**
     * Returns Breakdown.
     * The breakdown of the amount. Breakdown provides details such as total item amount, total tax amount,
     * shipping, handling, insurance, and discounts, if any.
     */
    public function getBreakdown(): ?AmountBreakdown
    {
        return $this->breakdown;
    }

    /**
     * Sets Breakdown.
     * The breakdown of the amount. Breakdown provides details such as total item amount, total tax amount,
     * shipping, handling, insurance, and discounts, if any.
     *
     * @maps breakdown
     */
    public function setBreakdown(?AmountBreakdown $breakdown): void
    {
        $this->breakdown = $breakdown;
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        $json['currency_code'] = $this->currencyCode;
        $json['value']         = $this->value;
        if (isset($this->breakdown)) {
            $json['breakdown'] = $this->breakdown;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
