@extends('layouts/fullLayoutMaster')

@section('title', __('locale.auth.register'))

@section('content')
    <div class="auth-wrapper auth-cover">
        <div class="auth-inner row m-0">
            <!-- Brand logo-->
            <a class="brand-logo" href="{{route('login')}}">
                <img src="{{asset(config('app.logo'))}}" alt="{{config('app.name')}}"/>
            </a>
            <!-- /Brand logo-->

            <!-- Left Text-->
            <div class="col-lg-3 d-none d-lg-flex align-items-center p-0">
                <div class="w-100 d-lg-flex align-items-center justify-content-center">
                    <img class="img-fluid w-100" src="{{asset('images/pages/create-account.svg')}}" alt="{{config('app.name')}}"/>
                </div>
            </div>
            <!-- /Left Text-->

            <!-- Register-->
            <div class="col-lg-9 d-flex align-items-center auth-bg px-2 px-sm-3 px-lg-5 pt-3">
                <div class="width-800 mx-auto card px-2 py-2">
                    <div class="card">
                        <div class="card-header"></div>
                        <div class="card-content">
                            <div class="card-body">
                                {!! $data->payment_details !!}
                                <br>
                                <h6 class="text-uppercase">For {{ __('locale.labels.payment_confirmation') }}:</h6>
                                {!! $data->payment_confirmation !!}


                                <form action="{{ route('payment.offline') }}" method="post" class="mt-2">
                                    @csrf
                                    <input type="hidden" name="user" value="{{ $user }}">
                                    <input type="hidden" name="plan" value="{{ $plan }}">
                                    <button type="submit" class="btn btn-success me-1 btn-submit">Claim Payment</button>
                                    <a href="{{ route('register') }}" class="btn btn-primary">{{ __('locale.buttons.back') }}</a>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
