<?php

    use Illuminate\Database\Migrations\Migration;
    use Illuminate\Database\Schema\Blueprint;
    use Illuminate\Support\Facades\Schema;

    class CreateSupportTicketsTable extends Migration
    {
        public function up(): void
        {
            Schema::create('support_tickets', function (Blueprint $table) {
                $table->id();
                $table->uuid()->unique();
                $table->string('subject');
                $table->longText('message');
                $table->enum('status', ['open', 'pending', 'resolved', 'closed'])->default('open');
                $table->enum('priority', ['low', 'medium', 'high', 'urgent'])->default('medium');
                $table->unsignedBigInteger('customer_id');
                $table->unsignedBigInteger('agent_id')->nullable();
                $table->unsignedBigInteger('category_id')->nullable();
                $table->boolean('is_public')->default(true);
                $table->timestamp('closed_at')->nullable();
                $table->timestamps();

                // Foreign keys
                $table->foreign('customer_id')->references('id')->on('users')->onDelete('cascade');
                $table->foreign('agent_id')->references('id')->on('users')->onDelete('set null');
                $table->foreign('category_id')->references('id')->on('support_categories')->onDelete('set null');
            });

            // Create support_labels table
            Schema::create('support_labels', function (Blueprint $table) {
                $table->id();
                $table->string('name')->unique();
                $table->string('color')->default('#6c757d'); // optional for visual labeling
                $table->timestamps();
            });

            // Create pivot table for ticket-label relationship
            Schema::create('support_label_ticket', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('support_ticket_id');
                $table->unsignedBigInteger('support_label_id');
                $table->timestamps();

                $table->foreign('support_ticket_id')->references('id')->on('support_tickets')->onDelete('cascade');
                $table->foreign('support_label_id')->references('id')->on('support_labels')->onDelete('cascade');

                $table->unique(['support_ticket_id', 'support_label_id'], 'ticket_label_unique');
            });
        }

        public function down(): void
        {
            Schema::dropIfExists('support_label_ticket');
            Schema::dropIfExists('support_labels');
            Schema::dropIfExists('support_tickets');
        }

    }
