<?php

    namespace App\Providers;

    use App\Helpers\Helper;
    use Illuminate\Support\Facades\View;
    use Illuminate\Support\ServiceProvider;
    use function App\Helpers\is_plugin_active;

    class MenuServiceProvider extends ServiceProvider
    {
        /**
         * Register services.
         *
         * @return void
         */
        public function register()
        {
            //
        }

        /**
         * Bootstrap services.
         *
         * @return void
         */
        public function boot()
        {
            // Load base menu
            $menuData = Helper::menuData();

            // Merge plugin menus if active
            if (is_plugin_active('codeglen/usupport')) {
                $menuData = \Codeglen\Usupport\Helper\Helper::supportMenu();
            }

            // Convert to object for Blade compatibility
            $verticalMenuData = json_decode(json_encode($menuData));

            // Share to all views
            View::share('menuData', [$verticalMenuData, $verticalMenuData]);
        }

    }
