<?php

    namespace App\Http\Controllers;


    use App\Helpers\Helper;
    use App\Library\StringHelper;
    use App\Library\Tool;
    use App\Models\AppConfig;
    use Exception;
    use Illuminate\Support\Facades\File;

    class PublicController extends Controller
    {

        public function termsOfUse()
        {
            $termsOfUse     = AppConfig::where('setting', 'terms_of_use')->first();
            $termsOfUseData = empty($termsOfUse) ? null : $termsOfUse->value;

            return view('auth.termsOfUses', compact('termsOfUseData'));

        }

        public function privacyPolicy()
        {

            $privacyPolicy     = AppConfig::where('setting', 'privacy_policy')->first();
            $privacyPolicyData = empty($privacyPolicy) ? null : $privacyPolicy->value;


            return view('auth.privacyPolicy', compact('privacyPolicyData'));

        }

        /**
         * @throws Exception
         */
        public function asset($dirname, $basename)
        {

            $dirname = StringHelper::base64UrlDecode($dirname);
            $absPath = storage_path(Helper::join_paths($dirname, $basename));

            if (File::exists($absPath)) {
                $mimetype = Tool::getFileType($absPath);

                return response()->file($absPath, [
                    'Content-Type'   => $mimetype,
                    'Content-Length' => filesize($absPath),
                ]);
            } else {
                abort(404);
            }
        }

    }
